/*! \file
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_defs.h
*
* Project, Target, subsystem:   Certificate Handling Toolkit, OMA DRM
*
* Created:                      28.01.2008
*
* Modified:                     28.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_DEF_H_
#define _TLK_CERT_DEF_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "CRYS_RSA_Types.h"

#define TLK_CERT_BITS_IN_BYTE                       (8)
#define TLK_CERT_MAX_EXTENEDED_KEY_USAGES           (5)
#define TLK_CERT_MAX_RSA_COMPONENT_SIZE             ((2048)/(TLK_CERT_BITS_IN_BYTE))

#define TLK_CERT_HASH_SHA1_RESULT_SIZE_IN_BYTES     (20)
#define TLK_CERT_SERIAL_NUMBER_MAX_LENGTH_IN_BYTES  (20)
#define TLK_CERT_NONCE_SIZE_IN_BYTES                (4)

#define TLK_CERT_MAC_LENGTH_IN_BYTES                (20)
#define TLK_CERT_INTERNAL_USE_SIZE_IN_BYTES         (4)
#define TLK_CERT_HASH_SHA1_RESULT_BASE64_SIZE   ((DX_DIVIDE_ROUND_UP(TLK_CERT_HASH_SHA1_RESULT_SIZE_IN_BYTES, (3)) * (4)) + (1))

#define TLK_CERT_EM_STRING_SIZE_IN_BYTES            (0x40)
#define TLK_CERT_PRIMITIVE_TAG_LEN_LENGTH_IN_BYTES  (3) /* Need to check */
#define TLK_CERT_DIGEST_INFO_BUFF_LENGTH_IN_BYTES   (0x40)

#define TLK_CERT_ASSERT_PARAM(condition)  if (!(condition)) return(DX_BAD_ARGUMENTS)
#define TLK_CERT_ASSERT(condition)        if (!(condition)) return(DX_ASSERTION_ERROR)

#define DX_CERT_MAX_SUPPORTED_VERSION                (2)

#define TLK_CERT_VERSION_3                           (2)

#define DX_HASH_SHA1_RESULT_SIZE                     (20)
#define DX_HASH_SHA1_RESULT_BASE64_SIZE              ((DX_DIVIDE_ROUND_UP(DX_HASH_SHA1_RESULT_SIZE, 3) * 4) + 1)

#define TLK_CERT_MIN_WORKSPACE_SIZE_IN_BYTES         (sizeof(CRYS_RSAPubUserContext_t) + sizeof(CRYS_RSAUserPubKey_t) + 0x00000128 /*sizeof(TLK_CERT_Cert_t)*/)

#define TLK_CERT_NONCE_MAC_PART_SIZE_IN_BYTES        (8)

#ifdef __cplusplus
}
#endif /*extern "C"*/

#endif

